# Contributing to the Radicle CI broker

The Radicle project welcomes contributions to the CI broker, as to all
other components of Radicle.

Development happens via Radicle. To propose a change, make a patch. If
you suspect the change needs discussion first, please first open an
issue or a topic on Zulip (preferably in the `#radicle-ci` channel).

* See [`README.md`](README.md) for how to run the test suite.
* We try to use [conventional
  commits](https://www.conventionalcommits.org/en/v1.0.0/), but it's
  not required.
* We use [Subplot](https://subplot.tech/) for documenting acceptance
  criteria and verifying they are met. This also acts as an
  integration test suite. We also test upgrades in the subplot.
* Unit tests are done in the usual Rust way.
* We use Radicle CI to test changes: we run [an
  instance](https://ci0.liw.fi/zwTxygwuz5LDGBq255RA2CbNGrz8.html) and
  a patch needs to pass CI to be merged. See
  [`.radicle/ambient.yaml`](.radicle/ambient.yaml).

If you're unsure about anything, don't hesitate to ask.

There are occasional office hours, where anything related to Radicle
CI can be discussed. Check the `#radicle-ci` topic on Zulip for when
and where.
