# Overview of Radicle CI

Radicle CI consists of the following functional components:

* `radicle-node` (part of [`heartwood`][]) communicates with other nodes to get updates
  and sends events when they've been stored in node storage
* `cib` (part of [`radicle-ci-broker`][]) receives the events,
  filters them, and decides when to trigger a CI run
* to execute a CI run, `cib` spawns an "adapter" as a
  sub-process; the adapter knows how to execute the CI run with
  some specific CI system; there's a different adapter for each
  kind of CI system
* when the adapter process finishes, it tells `cib` if the run
  succeeded or failed
* `cibtool` is a management tool for `cib`, which can trigger CI
  to run, tell `cib` to shut down, and so on

In addition:

* a Radicle repository can contain "job COBs", which are collaborative
  objects for keeping track of automated "jobs" related to specific
  commits in the repository, such as CI runs
* the `rad-job` tool can view or manipulate job COBs; it's part of the
  [`radicle-job`][] crate
* the [`radicle-desktop`][] app is a graphical user interface for managing
  Radicle repositories; it can show the result of CI runs of commits based
  on job COBs

The CI process is fundamentally:

* someone pushes a change to their Radicle node
* their node syncs the change to a node that runs CI
* `cib` decides to execute a CI run for the change
* `cib` spawns the appropriate adapter
* the adapter does whatever it needs to execute the run
* `cib` creates or updates a job COB accordingly


[`heartwood`]: https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:z3gqcJUoA1n9HaHKufZs5FCSGazv5
[`radicle-ci-broker`]: https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:zwTxygwuz5LDGBq255RA2CbNGrz8
[`radicle-job`]: https://app.radicle.xyz/nodes/seed.radicle.garden/rad%3Az2UcCU1LgMshWvXj6hXSDDrwB8q8M
[`radicle-desktop`]: https://app.radicle.xyz/nodes/seed.radicle.garden/rad%3Az4D5UCArafTzTQpDZNQRuqswh3ury
